package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.Node;

import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Commands;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.driver.DriverException;

public class RuntimeCommandFacade implements IRuntimeCommandFacade {

    private EventDispatcher dispatcher;
    private Logger logger = Logger.getLogger(RuntimeCommandFacade.class);
    private String presentationTemplateFile;

    public RuntimeCommandFacade(String presentationTemplateFile, EventDispatcher dispatcher) {
        this.presentationTemplateFile = presentationTemplateFile;
        this.dispatcher = dispatcher;
    }

    private void treatException(Exception e) {
        // gives feedback to the client that an error has occurred
        dispatcher.aborted(e.getMessage());
    }

    @Override
    public void clear(String nodeName) {
        logger.debug("Command request received: CLEAR " + nodeName);

        WorkflowProcess process = Commands.find();
        Node node = Commands.findNode(process.getProcessDefinition(), nodeName);
        
        if (node == null) {
        	logger.warn("Cannot remove breakpoint at " + nodeName);
        	return;
        }
        
        Commands.removeBreakpoint(process, node);
    }

    @Override
    public void resume() {
        try {
            logger.debug("Command request received: RESUME");

            WorkflowProcess process = Commands.find();
            Commands.resume(process);
        } catch (DriverException e) {
            treatException(e);
        }
    }

    @Override
    public void set(String nodeName) {
        logger.debug("Command request received: SET " + nodeName);
        WorkflowProcess process = Commands.find();
        Node node = Commands.findNode(process.getProcessDefinition(), nodeName);
        
        if (node == null) {
        	logger.warn("Cannot set breakpoint at " + nodeName);
        	return;
        }
        
        Commands.addBreakpoint(process, node);
    }

    @Override
    public void suspend() {
        logger.debug("Command request received: SUSPEND ");
        WorkflowProcess process = Commands.find();
        Commands.suspend(process);
    }

    @Override
    public String getStack() {
        StringBuilder result = new StringBuilder();
        
        WorkflowProcess process = Commands.find();
        result.append(presentationTemplateFile);
        result.append("|");
        result.append(process.getProcessDefinition().getName());
        result.append("|");
        result.append(process.getRootToken().getCurrentNode().getName());

        for (Object key : process.getContextInstance().getVariables().keySet()) {
            result.append("|");
            result.append(process.getContextInstance().getVariables().get(key).getClass().getName());
            result.append("|");
            result.append(key);
        }

        logger.debug("Command request received: STACK - " + result.toString());
        
        return result.toString();
    }

    @Override
    public String getVar(String name) {
        WorkflowProcess process = Commands.find();
        return new StringBuilder().append(process.getContextInstance().getVariable(name).getClass().getName()).append("|").append(process.getContextInstance().getVariable(name)).toString();
    }
}