package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public abstract class SocketListener implements Runnable {

    protected ServerSocket serverSocket;
    
    public SocketListener(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    @Override
    public void run() {
        waitForConnection();
    }

    protected void waitForConnection() {
        try {
            Socket clientSocket = serverSocket.accept();
    
            processClientSocket(clientSocket);
            
            clientSocket.close();
        } catch (IOException e) {
            treatException(e);
        }
    }

    protected void treatException(Exception e) {
        System.out.println(new StringBuilder().append("Accept failed: ").append(serverSocket.getLocalPort()).append(" due to ").append(e.getMessage()));
        System.exit(-1);
    }

    protected abstract void processClientSocket(Socket clientSocket) throws IOException;
}