package com.tandbergtv.watchpoint.studio.ui.command;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.actions.ToggleBreakpointsTargetManager;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * @author ehuahao
 */
@SuppressWarnings("restriction")
public class ToggleBreakpointCommandHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPart part = window.getPartService().getActivePart();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IToggleBreakpointsTarget target = ToggleBreakpointsTargetManager.getDefault().getToggleBreakpointsTarget(
                    part, selection);
            if (target instanceof IToggleBreakpointsTargetExtension) {
                try {
                    ((IToggleBreakpointsTargetExtension) target).toggleBreakpoints(part, selection);
                } catch (CoreException e) {
                    throw new ExecutionException("Error", e);
                }
            }
        }

        return null;
    }
}