package com.tandbergtv.watchpoint.studio.application;

import java.io.IOException;
import java.util.Properties;

/**
 * Loads application properties from the properties file.
 * 
 * @author Imran Naqvi
 *
 */
public class ApplicationProperties extends Properties {
	
	private static final long serialVersionUID = -2440412148987996833L;

	// The path to the Application Properties file
	private static final String PROPERTIES_FILE_PATH = "/application.properties";

	// Singleton Instance
	private static ApplicationProperties m_Instance;

	/**
	 * Singleton Accessor.
	 * 
	 * @return The Application Properties
	 * 
	 * @throws StudioRuntimeException
	 *             Failure to load the Application Properties File
	 */
	public static synchronized ApplicationProperties getInstance() {
		if (m_Instance == null) {
			m_Instance = new ApplicationProperties();
			m_Instance.loadProperties();
		}

		return m_Instance;
	}

	/*
	 * Private constructor to prevent instantiation
	 */
	private ApplicationProperties() {
	}

	/*
	 * Initialize the Properties by loading the values from the Application Properties file.
	 */
	private void loadProperties() {
		try {
			// Load the XML Properties File
			this.loadFromXML(this.getClass().getResourceAsStream(PROPERTIES_FILE_PATH));
		}
		catch (IOException ex) {
			String msg = "Failed to load the Application Properties.";
			throw new StudioRuntimeException(msg, ex);
		}
	}
}
