package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import java.text.MessageFormat;

import org.eclipse.core.resources.IResource;

import com.tandbergtv.watchpoint.studio.builder.resolution.ResolutionMessages;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class NodeVariableNotMappedInTemplateResolution extends WatchpointStudioTemplateResolution {

    private String variableName;
    private WPVariable containerVariable;

    public NodeVariableNotMappedInTemplateResolution(IResource markersResource, String element, String variableName, 
            WPVariable containerVariable) {
        super(markersResource, element, null);
        this.variableName = variableName;
        this.containerVariable = containerVariable;
    }

    @Override
    public String getLabel() {
        return MessageFormat.format(ResolutionMessages.VMC_NP_019, containerVariable.getName(), variableName);
    }

    @Override
    public void run() {
        try {
            WorkflowTemplate template = getTemplate();

            // get nodeDefinition
            NodeDefinition nd = (NodeDefinition) template.getNodeElementByName((String) element);
            WPVariable variable = nd.getVariable(variableName);
            variable.setName(containerVariable.getName());

            saveTemplate();

        } catch (Exception e) {
            Utility.reportError("Error while removing unused variable.", e);
        }
    }
}