/*
 * Created on Jun 22, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess;

/**
 * Maintains the Persistence Context
 * 
 * @author Vijay Silva
 */
public interface IPersistenceContext
{
	// ========================================================================
	// ==================== CONTEXT LIFECYCLE MANAGEMENT
	// ========================================================================

	/**
	 * Initialize the state of the Persistence Context
	 */
	void initialize();

	/**
	 * Close the Persistence Context ensuring any state is correctly terminated
	 */
	void close();

	// ========================================================================
	// ==================== CONTEXT TRANSACTION MANAGEMENT
	// ========================================================================

	/**
	 * Begin a new Transaction (if no transaction has already begun). The Persistence Context will
	 * keep track of the current transcation.
	 */
	void beginTransaction();

	/**
	 * Rollback the current transaction associated with the persistence context.
	 */
	void rollbackTransaction();

	/**
	 * Commit the current transaction associated with the persistence context.
	 */
	void commitTransaction();

	/**
	 * Gets the current transaction associated with the persistence context.
	 * 
	 * @return The current Transaction
	 */
	Object getCurrentTransaction();
}
