/*
* Created on June 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;


/**
 * Stores the Template's task nodes.
 * 
 * @author Francisco B. S. Neto
 * 
 */
public class TemplateManualTaskNodeDTO implements IWatchPointDTO, IPersistable {
	
	private static final long serialVersionUID = -379014790956472071L;

	private long id = DEFAULT_ID;

	private String name;
	
	private String resourceGroupName;
	
	private WorkflowTemplateDTO template;

	/**
	 * Default Constructor
	 */
	public TemplateManualTaskNodeDTO()
	{
		super();
	}

	/**
	 * Get the Node Definition Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * 
	 * @return the Id
	 */
	public long getId()
	{
		return id;
	}

	/**
	 * 
	 * @param id
	 *            The Id
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	public WorkflowTemplateDTO getTemplate() {
		return template;
	}

	public void setTemplate(WorkflowTemplateDTO template) {
		this.template = template;
	}
	
	public String getResourceGroupName() {
		return resourceGroupName;
	}

	public void setResourceGroupName(String resourceGroupName) {
		this.resourceGroupName = resourceGroupName;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 7 - 127;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof TemplateManualTaskNodeDTO))
			return false;

		TemplateManualTaskNodeDTO key = (TemplateManualTaskNodeDTO) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && key.id == DEFAULT_ID)
			return super.equals(key);

		return (this.id == key.id);
	}

	/**
	 * Creates a clone of the Node Definition.
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public TemplateManualTaskNodeDTO clone()
	{
		TemplateManualTaskNodeDTO clone = null;

		try
		{
			clone = (TemplateManualTaskNodeDTO) super.clone();

		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return "Name " + getName();
	}
}
