/**
 * ResourceConnectionType.java
 * Created Feb 10, 2010
 */
package com.tandbergtv.watchpoint.studio.external.jpf.model;

/**
 * @author Sahil Verma
 */
public enum ResourceConnectionType {
	/**
	 * A Connection URL
	 */
	URL(1, "URL"),

	/**
	 * IP Address with Optional Port Number
	 */
	IP_PORT(2, "IP/Port"),

	/**
	 * Email Address
	 */
	EMAIL(3, "Email");

	private final int id;

	private String displayName;

	/*
	 * Constructor
	 */
	ResourceConnectionType(int connectionTypeId, String displayName) {
		this.id = connectionTypeId;
		this.displayName = displayName;
	}

	/**
	 * @return Returns the displayName.
	 */
	public String getDisplayName() {
		return this.displayName;
	}

	/**
	 * @param displayName
	 *            The displayName to set.
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	/**
	 * @return Returns the id.
	 */
	public int getId() {
		return this.id;
	}

	/**
	 * Static method to get the ResourceConnectionType given the ResourceConnectionType Id
	 * 
	 * @param connectionTypeId
	 *            The Connection Type Id
	 * 
	 * @return The matching ResourceConnectionType or null if no match is found.
	 */
	public static ResourceConnectionType getById(Integer connectionTypeId) {
		if (connectionTypeId != null) {
			for (ResourceConnectionType connectionType : ResourceConnectionType.values()) {
				if (connectionType.getId() == connectionTypeId.intValue()) {
					return connectionType;
				}
			}
		}

		return null;
	}
}
