/*
 * Created on Jul 3, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.service;

/**
 * Contains all the available Service Error Codes (constants)
 * 
 * @author Vijay Silva
 */
public enum ServiceErrorCode
{
	// ========================================================================
	// ===================== GN - GENERAL SERVICE ERROR CODES
	// ========================================================================

	/**
	 * Error code for any general error.
	 */
	GENERAL_ERROR("SEC-GN-001"),

	/**
	 * Error code used when returning a set of validation errors.
	 */
	GENERAL_VALIDATION_ERROR("SEC-GN-002"),

	// ========================================================================
	// ===================== WT - WORKFLOW TEMPLATE SERVICE ERROR CODES
	// ========================================================================

	/**
	 * Error code if the workflow template xml is not valid xml.
	 */
	WT_INVALID_XML("SEC-WT-001"),

	/**
	 * Error code when attempting to edit a published template.
	 */
	WT_EDIT_PUBLISHED_ERROR("SEC-WT-002"),

	/**
	 * Error code when attempting to edit a template that could not be successfully locked.
	 */
	WT_EDIT_LOCK_ERROR("SEC-WT-003"),

	/**
	 * Error code when attempting to save a template with a lock for the template.
	 */
	WT_SAVE_UNLOCKED_ERROR("SEC-WT-004"),

	/**
	 * Error code when attempting to export a template that has not been published.
	 */
	WT_EXPORT_UNPUBLISHED_ERROR("SEC-WT-005"),

	/**
	 * Error code when attempting to publish a template that has been locked by another user.
	 */
	WT_PUBLISHED_LOCKED_ERROR("SEC-WT-006"),

	/**
	 * Error code when attempting to update the Version in the Workflow Template XML document.
	 */
	WT_VERSION_UPDATE_ERROR("SEC-WT-007"),

	/**
	 * Error code when attempting to get the node definitions ids specified in the Template Xml.
	 */
	WT_NODE_DEFN_UPDATE_ERROR("SEC-WT-008"),

	/**
	 * Error code when attempting to delete a Template that is locked by another user.
	 */
	WT_DELETE_LOCKED_ERROR("SEC-WT-009"),

	/**
	 * Error code when attempting to delete a Template that has already been published.
	 */
	WT_DELETE_PUBLISHED_ERROR("SEC-WT-010"),

	/**
	 * Error code when performing an operation on a Template that has already been deleted.
	 */
	WT_OPERATION_ON_DELETED_TEMPLATE("SEC-WT-011"),

	/**
	 * Error code when attempting to get the protection keys specified in the Template Xml.
	 */
	WT_PROTECTION_KEY_UPDATE_ERROR("SEC-WT-012"),

	/**
	 * Error code when attempting to get the resource group names specified in the Template Xml.
	 */
	WT_RESGRP_UPDATE_ERROR("SEC-WT-013"),

	// ========================================================================
	// ===================== ND - NODE DEFINITION SERVICE ERROR CODES
	// ========================================================================

	/**
	 * Error code if the node definition xml is not valid xml.
	 */
	ND_INVALID_XML("SEC-ND-001"),

	/**
	 * Error code when attempting to edit a published node definition.
	 */
	ND_EDIT_PUBLISHED_ERROR("SEC-ND-002"),

	/**
	 * Error code when attempting to edit a node definition that could not be successfully locked.
	 */
	ND_EDIT_LOCK_ERROR("SEC-ND-003"),

	/**
	 * Error code when attempting to save a node definition locked by another user.
	 */
	ND_SAVE_UNLOCKED_ERROR("SEC-ND-004"),

	/**
	 * Error code when attempting to export a node definition that has not been published.
	 */
	ND_EXPORT_UNPUBLISHED_ERROR("SEC-ND-005"),

	/**
	 * Error code when attempting to publish a node definition that has been locked by another user.
	 */
	ND_PUBLISHED_LOCKED_ERROR("SEC-ND-006"),

	/**
	 * Error code when attempting to get the node definitions ids specified in the node definition
	 * Xml.
	 */
	ND_NODE_DEFN_UPDATE_ERROR("SEC-ND-007"),

	/**
	 * Error code when attempting to delete a node definition that is locked by another user.
	 */
	ND_DELETE_LOCKED_ERROR("SEC-ND-008"),

	/**
	 * Error code when attempting to delete a node definition that has already been published.
	 */
	ND_DELETE_PUBLISHED_ERROR("SEC-ND-009"),

	/**
	 * Error code when performing an operation on a node definition that has already been deleted.
	 */
	ND_OPERATION_ON_DELETED_TEMPLATE("SEC-ND-010"),

	/**
	 * Error code when deleting a node definition that is being referenced by other node definitions
	 * or templates.
	 */
	ND_NODE_DEFN_REFERENCED("SEC-ND-011"),

	/**
	 * Error code when attempting to get the message uids specified in the node definition Xml.
	 */
	ND_MESSAGE_UPDATE_ERROR("SEC-ND-012"),
	
	/**
	 * Cannot edit Node Definition as it is of out-of-the-box Resource Type.
	 */
	ND_EDIT_RESTYPE_OOB_ERROR("SEC-ND-013"),

	/**
	 * Cannot delete Node Definition as it is of out-of-the-box Resource Type.
	 */
	ND_DELETE_RESTYPE_OOB_ERROR("SEC-ND-014"),
	
	/**
	 * Error code when attempting to delete the node definition in file system
	 */
	ND_DELETE_IN_FILE_SYSTEM_ERROR("SEC-ND-015"),
	
	/**
	 * Error code when attempting to create the node definition files in file system
	 */
	ND_CREATE_IN_FILE_SYSTEM_ERROR("SEC-ND-016"),
	
	/**
	 * Error code when attempting to update the node definition in file system
	 */
	ND_UPDATE_IN_FILE_SYSTEM_ERROR("SEC-ND-017"),
	
	// ========================================================================
	// ===================== RT - RESOURCE TYPE SERVICE ERROR CODES
	// ========================================================================

	/**
	 * Error code when attempting to delete a Resource Type after it has been exported.
	 */
	RT_DELETE_EXPORTED_ERROR("SEC-RT-001"),

	/**
	 * Error code when attempting to delete a Resource Type which is used by Resource Groups.
	 */
	RT_DELETE_USED_BY_RESOURCE_GROUP_ERROR("SEC-RT-002"),

	/**
	 * Error code when attempting to delete a Resource Type which is used by Node Definitions.
	 */
	RT_DELETE_USED_BY_NODE_DEFN_ERROR("SEC-RT-003"),

	/**
	 * Error code for failure when attempting to generate a Message UID.
	 */
	RT_UID_GENERATION_ERROR("SEC-RT-004"),

	/**
	 * Error code when attempting to delete a Message which is used by Node Definitions.
	 */
	RT_MESSAGE_DELETE_USED_BY_NODE_DEFN_ERROR("SEC-RT-005"),

	/**
	 * Error code when attempting to perform an operation on a Resource Type that has been deleted.
	 */
	RT_OPERATION_ON_DELETED_RESOURCE_TYPE("SEC-RT-006"),
	
	/**
	 * Cannot delete an out-of-the-box Resource Type.
	 */
	RT_DELETE_OOB_ERROR("SEC-RT-007"),

	/**
	 * Cannot delete a Message that belongs to an out-of-the-box Resource Type. 
	 */
	RT_MESSAGE_DELETE_OOBRESTYPE_ERROR("SEC-RT-008"),

	/**
	 * Modifying an out-of-the-box Resource Type is not allowed.
	 */
	RESOURCE_TYPE_CANNOT_UPDATE_OOBRESTYPE("SEC-RT-009"),
	
	/**
	 * Creation of a new Message for out-of-the-box Resource Type is not allowed.
	 */
	MESSAGE_CANNOT_CREATE_OOBRESTYPE("SEC-RT-010"),
	
	/**
	 * Error code when attempting to delete the resource type in file system
	 */
	RT_DELETE_IN_FILE_SYSTEM_ERROR("SEC-RT-011"),
	
//	/**
//	 * Error code when attempting to create the resource type files in file system
//	 */
//	RT_CREATE_IN_FILE_SYSTEM_ERROR("SEC-RT-012"),
	
	/**
	 * Error code when attempting to update the resource type in file system
	 */
	RT_UPDATE_IN_FILE_SYSTEM_ERROR("SEC-RT-013");



	// The Error Code value
	private final String code;

	/*
	 * Constructor
	 */
	ServiceErrorCode(String code)
	{
		this.code = code;
	}

	/**
	 * Get the Error Code associated with this value.
	 * 
	 * @return The code used.
	 */
	public String getCode()
	{
		return this.code;
	}

	/**
	 * Get the ServiceErrorCode for the given code.
	 * 
	 * @param code
	 *            The Error Code
	 * 
	 * @return The corresponding ServiceErrorCode
	 */
	public static ServiceErrorCode getServiceErrorCode(String code)
	{
		for (ServiceErrorCode serviceErrorCode : ServiceErrorCode.values())
		{
			if (serviceErrorCode.getCode().equals(code))
			{
				return serviceErrorCode;
			}
		}

		return null;
	}
}
