package com.tandbergtv.watchpoint.studio.ui.command;

import org.jbpm.gd.jpdl.command.NodeCreateCommand;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import com.tandbergtv.watchpoint.studio.external.wpexport.impl.template.UniqueNodeNameGenerator;
import com.tandbergtv.watchpoint.studio.ui.editor.WPNodeContainer;

/**
 * Command class for creating nodes. 
 * Takes in consideration that the initial node name must be unique in the
 * whole template - considering child LoopNodes.
 * 
 * @see org.jbpm.gd.jpdl.command.NodeCreateCommand 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class WPNodeCreateCommand extends NodeCreateCommand {
	private NodeElementContainer getRootNodeElementContainer() {
		if (parent instanceof WPNodeContainer) {
			WPNodeContainer container = (WPNodeContainer) parent;
			return (NodeElementContainer) container.getContainer().getSemanticElement();
		} else {
			return getNodeElementContainer();
		}
	}
    
    @Override
    protected void setName() {
        if (getAbstractNode().getName() == null) {
            UniqueNodeNameGenerator nameHelper = new UniqueNodeNameGenerator(false);
            nameHelper.setRootContainer(getRootNodeElementContainer());
            nameHelper.setUniqueNodeNameFor(getAbstractNode());
        }
    }
}
