package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class TemplateEditorContextManager {
	
	private static TemplateEditorContextManager instance = null;
	private static IContextActivation templateEditorContextActivation = null;
	
	private TemplateEditorContextManager(){}
	
	public static TemplateEditorContextManager getInstance(){
		if( instance == null){
			instance = new TemplateEditorContextManager();
		} 
		return instance;
	}
	
	public static void activateTemplateEditorContext(){
		IContextService contextService = (IContextService) PlatformUI.getWorkbench().getService(IContextService.class);
		if(templateEditorContextActivation == null){
			templateEditorContextActivation = contextService.activateContext("com.tandbergtv.watchpoint.template.editor.context");
		}
	}
	
	public static boolean isContextActivated(){
		boolean isActivated = false;
		if( templateEditorContextActivation != null )
			isActivated = true;
		return isActivated;
	}
	
	public static void deactivateTemplateEditorContext(){
		IContextService contextService = (IContextService) PlatformUI.getWorkbench().getService(IContextService.class);
		if(templateEditorContextActivation != null){
			contextService.deactivateContext(templateEditorContextActivation);
			templateEditorContextActivation = null;
		}
	}

}
