/*
 * Created on Oct 1, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditorInput;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage.ResourceTypeFormPage;

/**
 * Details Page for a Resource Type Message
 * 
 * @author Vijay Silva
 */
public class MessageDetailsPage implements IDetailsPage
{
	IManagedForm managedForm;

	Composite parentComposite;

	MessageDetailsSectionPart messageDetailsSectionPart;

	AbstractFormPart masterPart;

	IEditorPart editorPart;

	/**
	 * Constructor
	 * 
	 * @param parentPart
	 *            The Part that contains this composite
	 * @param masterPart
	 *            The Form Part that contains the Master Form
	 */
	public MessageDetailsPage(IEditorPart parentPart, AbstractFormPart masterPart)
	{
		this.editorPart = parentPart;
		this.masterPart = masterPart;
	}

	/**
	 * @see org.eclipse.ui.forms.IDetailsPage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	public void createContents(Composite parent)
	{
		this.parentComposite = parent;

		FormToolkit toolkit = this.getManagedForm().getToolkit();
		int style = ResourceTypeFormPage.getDefaultSectionStyle();
		this.messageDetailsSectionPart = new MessageDetailsSectionPart(this.editorPart, parent,
				toolkit, style);
		this.messageDetailsSectionPart.setMessageMasterPart(this.masterPart);

		/* Set the Layout Data for the Section in the Page */
		GridLayout gridLayout = new GridLayout(1, false);
		gridLayout.marginLeft = gridLayout.marginRight = 0;
		gridLayout.marginTop = gridLayout.marginBottom = 0;
		gridLayout.marginHeight = gridLayout.marginWidth = 10;
		parent.setLayout(gridLayout);

		GridData gridData = new GridData(SWT.FILL, SWT.BEGINNING, true, false);
		Section messageSection = this.messageDetailsSectionPart.getSection();
		messageSection.setLayoutData(gridData);
		messageSection.setText("Message Details");
		this.getManagedForm().addPart(this.messageDetailsSectionPart);
	}

	/**
	 * @see org.eclipse.ui.forms.IPartSelectionListener#selectionChanged(org.eclipse.ui.forms.IFormPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IFormPart part, ISelection selection)
	{
		Object selectedObject = null;

		if (selection instanceof IStructuredSelection)
		{
			IStructuredSelection structuredSelection = (IStructuredSelection) selection;
			selectedObject = structuredSelection.getFirstElement();
		}

		this.setFormInput(selectedObject);
	}

	/**
	 * @return the managedForm
	 */
	public IManagedForm getManagedForm()
	{
		return this.managedForm;
	}

	// ========================================================================
	// ===================== IFORMPART METHODS
	// ========================================================================

	/**
	 * @see org.eclipse.ui.forms.IFormPart#initialize(org.eclipse.ui.forms.IManagedForm)
	 */
	public void initialize(IManagedForm managedForm)
	{
		this.managedForm = managedForm;
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#isDirty()
	 */
	public boolean isDirty()
	{
		boolean dirty = false;

		if (this.messageDetailsSectionPart != null)
			dirty = this.messageDetailsSectionPart.isDirty();

		return dirty;
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#isStale()
	 */
	public boolean isStale()
	{
		boolean stale = false;

		if (this.messageDetailsSectionPart != null)
			stale = this.messageDetailsSectionPart.isStale();

		return stale;
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#refresh()
	 */
	public void refresh()
	{
		if (this.messageDetailsSectionPart != null)
			this.messageDetailsSectionPart.refresh();
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#commit(boolean)
	 */
	public void commit(boolean onSave)
	{
		if (this.messageDetailsSectionPart != null)
			this.messageDetailsSectionPart.setResourceTypeInput((ResourceTypeEditorInput)getManagedForm().getInput());
			this.messageDetailsSectionPart.commit(onSave);
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#setFormInput(java.lang.Object)
	 */
	public boolean setFormInput(Object input)
	{
		boolean result = false;

		if (this.messageDetailsSectionPart != null)
			result = this.messageDetailsSectionPart.setFormInput(input);

		return result;
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#setFocus()
	 */
	public void setFocus()
	{
		if (this.messageDetailsSectionPart != null)
			this.messageDetailsSectionPart.setFocus();
	}

	/**
	 * @see org.eclipse.ui.forms.IFormPart#dispose()
	 */
	public void dispose()
	{
		if (this.messageDetailsSectionPart != null)
			this.messageDetailsSectionPart.dispose();
	}
}
