package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.application.ApplicationProperties;
import com.tandbergtv.watchpoint.studio.application.ApplicationPropertyKeys;
import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;
import com.tandbergtv.watchpoint.studio.util.SemanticElementCloneUtil;


/**
 * Model representation of a Manual TaskNode.
 * 
 * @author Imran Naqvi
 * 
 */
public class ManualTaskNode extends AbstractTaskNode implements IHumanResourceTypeElement, IWPVariableContainer {

	/**
	 * Constructor. Sets the resource type id for human resource type.
	 */
	public ManualTaskNode() {
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void initialize() {
		if (getAction() == null) {
			Action action = (Action) getFactory().createById(SemanticElementConstants.ACTION_SEID);
			ApplicationProperties properties = ApplicationProperties.getInstance();
			String defaultHandler = properties.getProperty(ApplicationPropertyKeys.MANUAL_TASK_HANDLER);
			
			action.setClassName(defaultHandler);
			
			setAction(action);
		}
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IResourceTypeElement#getResourceType()
	 */
	public long getResourceType() {
		throw new StudioRuntimeException("Operation not supported.");
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer#addVariable(com.tandbergtv.watchpoint.studio.ui.model.WPVariable)
	 */
	public void addVariable(WPVariable variable) {
		Task[] tasks = getTasks();
		if(tasks == null || tasks.length == 0) {
			throw new StudioRuntimeException("No task found");
		}
		tasks[0].getController().addVariable(variable);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer#getVariables()
	 */
	public List<WPVariable> getVariables() {
		List<WPVariable> wpVariables = new ArrayList<WPVariable>();
		Task[] tasks = getTasks();
		if(tasks != null && tasks.length > 0) {
			Variable[] variables = tasks[0].getController().getVariables();
			if(variables != null && variables.length > 0) {
				for(Variable variable : variables) {
					wpVariables.add((WPVariable)variable);
				}
			}
		}
		return wpVariables;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer#removeVariable(java.lang.String)
	 */
	public WPVariable removeVariable(String name) {
		Task[] tasks = getTasks();
		if(tasks == null || tasks.length == 0) {
			throw new StudioRuntimeException("No task found");
		}
		Variable[] variables = tasks[0].getController().getVariables();
		if(variables != null && variables.length > 0) {
			for(Variable variable : variables) {
				String variableName = variable.getName();
				if(variableName != null && variableName.equals(name)) {
					tasks[0].getController().removeVariable(variable);
					return (WPVariable) variable;
				}
			}
		}
		return null;
	}

    /* (non-Javadoc)
     * @see com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer#hasVariables()
     */
	public boolean hasVariable(String name) {
		for (WPVariable variable : getVariables()) {
			if (variable.getMappedName().equals(name))
				return true;
		}
		
		return false;
	}

	public ManualTaskNode cloneManualTaskNode(){
		return SemanticElementCloneUtil.cloneManualTaskNode(this);
	}

    public WPVariable addEmptyVariable(String variableName) {
        Task task = getNonEmptyTask();

        WPVariable variable = (WPVariable) getFactory().createById(SemanticElementConstants.VARIABLE_SEID);
        variable.setMappedName(variableName); 
        variable.setName(variableName);
        variable.setType(DataType.STRING.name());
        variable.setValue("");
        variable.setAccess("read,write");
        task.getController().addVariable(variable);
        return variable;
    }

    private Task getNonEmptyTask() {
        Task task = (getTasks() != null && getTasks().length > 0) ? getTasks()[0] : null;
        if (task == null) {
            task = (Task) getFactory().createById(SemanticElementConstants.TASK_SEID);
            addTask(task);
        }

        Controller controller = task.getController();
        if (controller == null) {
            controller = (Controller) getFactory().createById(SemanticElementConstants.CONTROLLER_SEID);
            task.setController(controller);
        }
        
        return task;
    }

    public void removeVariable(WPVariable variable) {
        getNonEmptyTask().getController().removeVariable(variable);
    }
}