package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.jbpm.gd.common.model.AbstractSemanticElement;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.ProcessDefinition;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;

/**
 * Model representation of a Workflow Template.
 * 
 * @author Imran Naqvi
 * 
 */
public class WorkflowTemplate extends ProcessDefinition implements IProtectionKeyElement{

	private long id;
	private int version;
	private Set<ProtectionKey> protectionKeys = new HashSet<ProtectionKey>();
    private String location;

	/**
	 * @return the version
	 */
	public int getVersion() {
		return version;
	}

	/**
	 * @param newVersion
	 *            the version to set
	 */
	public void setVersion(int newVersion) {
		int oldVersion = this.version;
		this.version = newVersion;
		firePropertyChange("version", oldVersion, newVersion);
	}

	/**
	 * @return the id
	 */
	public long getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id) {
		this.id = id;
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement#getProtectionKeys()
	 */
	public Set<ProtectionKey> getProtectionKeys() {
		return protectionKeys;
	}
	
	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement#addProtectionKey(com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey)
	 */
	public void addProtectionKey(ProtectionKey key) {
		this.protectionKeys.add(key);
		firePropertyChange("pkAdd", null, key);
	}

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.ui.model.IProtectionKeyElement#removeProtectionKey(com.tandbergtv.watchpoint.studio.ui.model.ProtectionKey)
	 */
	public void removeProtectionKey(ProtectionKey key) {
		this.protectionKeys.remove(key);
		firePropertyChange("pkRemove", key, null);
	}
	
	/**
	 * Returns a list of node elements that are node definitions and have the given ID
	 * 
	 * @param id
	 * @return
	 */
	public Collection<NodeElement> findNodes(long id) {
		Collection<NodeElement> nodes = new ArrayList<NodeElement>();
		NodeElement [] elements = getNodeElements();
		
		for (NodeElement element : elements) {
			if (element instanceof NodeDefinition && NodeDefinition.class.cast(element).getId() == id)
				nodes.add(element);
		}
		
		return nodes;
	}
	
	/**
	 * Returns a list of node elements that are node definitions and have the given ID. Superstate
	 * children that match the ID are also included.
	 * 
	 * @param id
	 * @return
	 */
	public Collection<NodeElement> findNodesRecursively(long id) {
		Collection<NodeElement> nodes = new ArrayList<NodeElement>();
		NodeElement [] elements = getNodeElements();
		
		for (NodeElement element : elements) {
			if (!(element instanceof NodeDefinition))
				continue;
			
			NodeDefinition node = NodeDefinition.class.cast(element);
			
			if (node.getId() == id) {
				nodes.add(node);
			} else if (node.getNodeType() == NodeDefinitionType.SuperState) {
				nodes.addAll(node.findNodes(id));
			}
		}
		
		return nodes;
	}

    public void setLocation(String location) {
        this.location = location;
    }

    public String getLocation() {
        return location;
    }

    @Override
    public void addNodeElement(NodeElement nodeElement) {
        if (nodeElement != null) {
            ((WPNodeElement) nodeElement).setParent(this);
        }
        super.addNodeElement(nodeElement);
    }

    @Override
    public void removeNodeElement(NodeElement nodeElement) {
        if (nodeElement != null) {
            ((WPNodeElement) nodeElement).setParent(null);
        }
        super.removeNodeElement(nodeElement);
    }

    public boolean hasVariable(String variableName) {
        if (getStartState() != null && getStartState().getTask() != null
                && getStartState().getTask().getController() != null
                && getStartState().getTask().getController().getVariables() != null) {
            for (Variable variable : getStartState().getTask().getController().getVariables()) {
                if (variable.getName().equals(variableName)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void accept(SemanticElementVisitor visitor) {
        for (NodeElement nodeElement : getNodeElements()) {
            ((AbstractSemanticElement)nodeElement).accept(visitor);
        }
        visitor.visit(this);
    }

    @Override
    public void addStartState(StartState startState) {
        startState.setParent(this);
        super.addStartState(startState);
    }
}