/**
 * ITreeNode.java
 * Created Apr 15, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.model.tree;

import java.util.List;

/**
 * A tree node. Each node has data, a pointer to its parent and an ordered list of children
 * 
 * @author Sahil Verma
 */
public interface ITreeNode<T> {
	
	/**
	 * Gets the data associated with this node
	 * 
	 * @return
	 */
	T getData();
	
	/**
	 * Adds a child to the end of the list
	 * 
	 * @param child
	 */
	void addChild(ITreeNode<T> child);
	
	/**
	 * Removes the specified node from the list of children
	 * 
	 * @param child
	 */
	void removeChild(ITreeNode<T> child);
	
	/**
	 * Returns the ordered list of children
	 * 
	 * @return
	 */
	List<ITreeNode<T>> getChildren();
	
	/**
	 * Returns the parent node
	 * 
	 * @return
	 */
	ITreeNode<T> getParent();
	
	/**
	 * Returns true if this node has children
	 * 
	 * @return
	 */
	boolean hasChildren();
}
