/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter for  Non Nested single-node node definitions. This filter is only for the node definition editor.
 * 
 * @author Imran Naqvi
 * 
 */
public class CustomActionFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if(this.container == null)
			return false;
		
		if(!(modelElement instanceof AutomaticTaskNode))
			return false;
		if ( container instanceof NodeDefinition ) {
			NodeDefinitionType nodeType = ((NodeDefinition)container).getNodeType();
			if( nodeType==NodeDefinitionType.MessageNode ){
				return false;
			}
		}

		return true;
	}
}
