/*
 * Created on Aug 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.eclipse.gef.EditPart;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.notation.JpdlNode;
import org.jbpm.gd.jpdl.notation.JpdlRootContainer;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.editor.WPNodeContainer;
import com.tandbergtv.watchpoint.studio.ui.model.AssignNode;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.IDueDateElement;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

/**
 * Filter used for the DueDateElementSection to determine if the section needs to be displayed.
 * 
 * @author Vijay Silva
 */
public class DueDateSectionFilter extends WPPropertyFilter {
	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if (!(modelElement instanceof IDueDateElement))
			return false;
		
		if(this.container == null)
			return false;
		
		if ((modelElement instanceof NodeDefinition)
				&& container instanceof NodeDefinition) {
			NodeDefinition root = (NodeDefinition) container;
			/*Due Date is not allowed for nested node definitions*/
			if (!((NodeDefinition) modelElement).getName().equals(root.getName()))
				return false;
		}

		// Due Date is allowed for all elements except Automatic Task Node
		return !(modelElement instanceof AutomaticTaskNode) && !(modelElement instanceof AssignNode);
	}

	@Override
	public boolean select(Object toTest) {
		if(toTest instanceof EditPart){
			SemanticElement rootElement = null;
			Object modelObject = ((EditPart)toTest).getModel();
			if(modelObject instanceof JpdlNode){
				rootElement = ((JpdlNode) modelObject).getContainer().getSemanticElement();
				JpdlNode mo = (JpdlNode) modelObject;
				/* Checks if the node container is a loop node. 
				 * If so, checks if this loop node is a child of a superstate.  */
				if(mo.getContainer() instanceof WPNodeContainer){
					WPNodeContainer nc = (WPNodeContainer) mo.getContainer();
					if( nc.getContainer().getSemanticElement() instanceof NodeDefinition ){
						NodeDefinition nd = (NodeDefinition)nc.getContainer().getSemanticElement();
						if( NodeDefinitionType.SuperState.equals(nd.getNodeType()) ){
							return false;
						}
					}
				}
			} else if (modelObject instanceof JpdlRootContainer){
				rootElement = ((JpdlRootContainer) modelObject).getSemanticElement();
			}
			
			if(rootElement != null && rootElement instanceof NodeElementContainer)
				container = (NodeElementContainer) rootElement;
		}
		SemanticElement modelElement = this.getModelElement(toTest);
		return this.selectModelElement(modelElement);
	}
}
