package com.tandbergtv.watchpoint.studio.ui.properties.nodedefinition;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.WPLabelProvider;

public class NodeDefinitionVariablesLabelProvider extends WPLabelProvider {

    public NodeDefinitionVariablesLabelProvider(TableColumn attachmentColumn, TableColumn keyColumn) {
        this.columns = new TableColumn[] { attachmentColumn, null, keyColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 1:
            if (model.getError() != null && ((Object[]) model.getError())[0].equals(Boolean.TRUE)) {
                return getImage(FieldDecorationRegistry.DEC_ERROR);
            } else if (!model.isWritable()) {
                return getImage(FieldDecorationRegistry.DEC_CONTENT_PROPOSAL);
            }
            return null;
        case 2:
            return getCheckImage(model.isAttachment());
        case 4:
            return getCheckImage(model.isCompositeKey());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        WPVariable variable = ((WPVariable) element);
        switch (columnIndex) {
        case 0:
            boolean isRequired = false;
            if (variable.getSuperStateInfo() != null) {
                isRequired = variable.getSuperStateInfo().isRequired();
            } else {
                isRequired = variable.isReadable();
            }
            return variable.getMappedName() + (isRequired ? " *" : "");
        case 1:
            return variable.getName();
        case 3:
            return variable.getEmptySafeType();
        }
        return null;
    }
}