/**
 * UpdateNodeCommand.java
 * Created Apr 20, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.IUpdateElement;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Updates an existing node
 * 
 * @author Sahil Verma
 */
public class UpdateNodeCommand extends AbstractNodeCommand {
	
	protected NodeDefinitionDTO localModel;
	
	/**
	 * @param name
	 * @param description
	 */
	public UpdateNodeCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		IUpdateElement updateElement = IUpdateElement.class.cast(diff);
		
		this.localModel = (NodeDefinitionDTO) updateElement.getLocalModel();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void execute() {
		localModel = context.mergeNode(localModel);
		
		super.execute();
		
		localModel.setGpd(model.getGpd());
		localModel.setXml(model.getXml());
		
		context.updateNode(localModel);
	}
	
	protected void updateRelationships() {
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return "Node " + model.getName() + " " + diff.getKind();
	}
}
