package com.tandbergtv.watchpoint.studio.ui.util;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.SemanticElementConstants;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class ModelHandler {
    private ModelHandler() {}
    
    public static WPVariable addEmptyVariableToProcessState(ProcessState target, String variableName) {
        WPVariable variable = (WPVariable) target.getFactory().createById(SemanticElementConstants.VARIABLE_SEID);
        variable.setName(variableName);
        variable.setMappedName("");
        variable.setAccess("read");
        target.addVariable(variable);

        return variable;
    }
    
    public static StartState createStartStateWithVariables(List<WPVariable> variables) {
        StartState startState = new StartState();
        if (startState.getFactory() == null) {
            startState.setFactory(new SemanticElementFactory(Utility.TEMPLATE_EDITOR_ID));
        }
        
        Task task = startState.getTask();
        if (task == null) {
           task = (Task) startState.getFactory().createById(SemanticElementConstants.TASK_SEID);
           startState.setTaskWithoutNotification(task);
        }
        if (task.getController() == null) {
            task.setController((Controller) startState.getFactory().createById(SemanticElementConstants.CONTROLLER_SEID));
        }
        for (WPVariable variable : variables) {
            task.getController().addVariable(variable);
        }
        
        return startState;
    }
    
    public static List<WPVariable> getStartStateVariables(StartState startState) {
    	Task task = startState.getTask();
        List<WPVariable> variables = new ArrayList<WPVariable>();
        if (task == null || task.getController() == null || task.getController().getVariables() == null) {
            return variables;
        }

        for (Variable variable : task.getController().getVariables()) {
            variables.add((WPVariable) variable);
        }
        return variables;
    }

    public static List<WPVariable> getStartStateValidVariables(StartState startState) {
        List<WPVariable> allVariables = getStartStateVariables(startState);
        List<WPVariable> validVariables = new ArrayList<WPVariable>(); 
        for (WPVariable variable : allVariables) {
            if (variable.isNameValid()) {
                validVariables.add(variable);
            }
        }
        return validVariables;
    }

    public static WPVariable getStartStateVariable(StartState startState, String name) {
        for (WPVariable variable : getStartStateValidVariables(startState)) {
            if (variable.getName().equals(name)) {
                return variable;
            }
        }
        return null;
    }

    public static WPVariable addStartStateEmptyVariable(StartState startState, String variableName) {
        Task task = getStartStateNonEmptyTask(startState);

        WPVariable variable = (WPVariable) startState.getFactory().createById(SemanticElementConstants.VARIABLE_SEID);
        variable.setMappedName(variableName); 
        variable.setName(variableName);
        variable.setType(DataType.STRING.name());
        variable.setValue("");
        variable.setAccess("read,write");
        task.getController().addVariable(variable);
        return variable;
    }

    public static void removeStartStateVariable(StartState startState, WPVariable variable) {
    	getStartStateNonEmptyTask(startState).getController().removeVariable(variable);
    }
    
    private static Task getStartStateNonEmptyTask(StartState startState) {
        Task task = startState.getTask();
        if (task == null) {
            task = (Task) startState.getFactory().createById(SemanticElementConstants.TASK_SEID);
            startState.setTask(task);
        }

        Controller controller = task.getController();
        if (controller == null) {
            controller = (Controller) startState.getFactory().createById(SemanticElementConstants.CONTROLLER_SEID);
            task.setController(controller);
        }
        
        return task;
    }
}
