/**
 * Importers.java
 * Created Feb 22, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.wizard.imports;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.wizard.resource.ResourceTypeImportService;

/**
 * Factory for importers
 * 
 * @author Sahil Verma
 */
public class Importers {
	
	/**
	 * Creates an importer
	 * 
	 * @param dto
	 * @return
	 */
	public static Importer getImporter(Class<? extends IWatchPointDTO> clazz) {
		/* FIXME Use an extension point */
		if (clazz.equals(ResourceType.class))
			return new ResourceTypeImportService();
		
		throw new IllegalArgumentException("Class " + clazz.getSimpleName() + " not supported");
	}
}
