package com.tandbergtv.watchpoint.studio.ui.xml;

import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

/**
 * SuperstateNodeDefinitionDomAdapter.java
 * Created Sep 17, 2010
 */
public class SuperstateNodeDefinitionDomAdapter extends NodeDefinitionDomAdapter {

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void initialize() {
		if (getSemanticElement() != null) {
			NodeDefinition nodeDefinition = (NodeDefinition) getSemanticElement();
			nodeDefinition.setNodeType(NodeDefinitionType.SuperState);
			setAttribute("name", nodeDefinition.getName());
			setAttribute("definitionName", nodeDefinition.getDefinitionName());
			setAttribute("id", String.valueOf(nodeDefinition.getId()));
			setAttribute("resourceType", String.valueOf(nodeDefinition.getResourceType()));
			
			if(nodeDefinition.getNode() != null && nodeDefinition.getNode() instanceof NodeGroup){
				NodeGroup current = (NodeGroup)nodeDefinition.getNode();
				addElement(current);
			}else {
				/* Adding node elements */
				addElements(nodeDefinition.getNodeElements());
			}
			
			/* Adding start variables */
			if (nodeDefinition.getNode() instanceof NodeElementContainer) {
				List<WPVariable> variables = nodeDefinition.getVariables();
				addElements((WPVariable[]) variables.toArray(new WPVariable[variables.size()]));
			}
			/*Add Transitions*/
			addElements(nodeDefinition.getTransitions());
			/*Add Description*/
			addElement(nodeDefinition.getDescription());
			
		}
	}
}

