/*
 * Created on Aug 2, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.util;

/**
 * Exception that occurs when the plugin file generation fails.
 * 
 * @author Patrik Araujo
 */
public class PluginFileGenerationException extends Exception
{
	private static final long serialVersionUID = -7636098386717940854L;

	/**
	 * Constructor
	 */
	public PluginFileGenerationException()
	{
		super();
	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            The detail message
	 * @param cause
	 *            The nested throwable
	 */
	public PluginFileGenerationException(String message, Throwable cause)
	{
		super(message, cause);
	}

	/**
	 * Constructor
	 * 
	 * @param message
	 *            The detail message
	 */
	public PluginFileGenerationException(String message)
	{
		super(message);
	}

	/**
	 * Constructor
	 * 
	 * @param cause
	 *            The nested throwable
	 */
	public PluginFileGenerationException(Throwable cause)
	{
		super(cause);
	}
}
