/*
 * Created on Jul 17, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.graph;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.UserDataContainer;

/**
 * Class containing utility methods related to the Watchpoint Graph implementations.
 * 
 * @author Vijay Silva
 */
public final class WatchPointGraphUtils
{
	/*
	 * Cannot instantiate
	 */
	private WatchPointGraphUtils()
	{
	}

	/**
	 * Get the Element associated with the Graph or Graph Element (Vertex, Edge).
	 * 
	 * @param container
	 *            The Graph or Graph element which serves as a user data container.
	 * 
	 * @return The element contained with key: GraphFactory.ELEMENT_KEY
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.graph.IWatchPointGraph#ELEMENT_KEY
	 */
	public static Object getElement(UserDataContainer container)
	{
		return container.getUserDatum(IWatchPointGraph.ELEMENT_KEY);
	}

	/**
	 * Gets the Node Element contained in the Workflow Template graph
	 * 
	 * @param graph
	 *            The Workflow Template Graph
	 * 
	 * @return The Workflow Template element that the graph represents
	 */
	public static WorkflowTemplate getWTGraphElement(WorkflowTemplateGraph graph)
	{
		return (WorkflowTemplate) graph.getUserDatum(IWatchPointGraph.ELEMENT_KEY);
	}

	/**
	 * Gets the Node Element contained in the WorkflowTemplate graph vertex
	 * 
	 * @param vertex
	 *            The Vertex
	 * 
	 * @return The Node Element that the vertex represents
	 */
	public static NodeElement getWTVertexElement(Vertex vertex)
	{
		return (NodeElement) vertex.getUserDatum(IWatchPointGraph.ELEMENT_KEY);
	}

	/**
	 * Gets the Transition contained in the WorkflowTemplate graph edge
	 * 
	 * @param edge
	 *            The Edge
	 * 
	 * @return The Transition that the edge represents
	 */
	public static Transition getWTEdgeElement(Edge edge)
	{
		return (Transition) edge.getUserDatum(IWatchPointGraph.ELEMENT_KEY);
	}
}
