/*
 * Created on Jul 11, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.impl;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/**
 * Exception class indicating that the Validator is undefined for a particular class of object since
 * the Validation Rules are not configured for the object.
 * 
 * @author Vijay Silva
 */
public class ValidatorUndefinedException extends StudioRuntimeException
{
	private static final long serialVersionUID = 2366047305274155949L;

	/**
	 * 
	 */
	public ValidatorUndefinedException()
	{
	}

	/**
	 * @param message
	 *            The detail message
	 */
	public ValidatorUndefinedException(String message)
	{
		super(message);
	}

	/**
	 * @param cause
	 *            The cause
	 */
	public ValidatorUndefinedException(Throwable cause)
	{
		super(cause);
	}

	/**
	 * @param message
	 *            The detail message
	 * @param cause
	 *            The cause
	 */
	public ValidatorUndefinedException(String message, Throwable cause)
	{
		super(message, cause);
	}

}
