/*
 * Created on Nov 15, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.actionvariable;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.model.ActionVariable;

/**
 * Rule that validates that the value of the ActionVariable is a positive integer.
 * 
 * @author Vijay Silva
 */
public class PositiveIntegerValueRule extends ActionVariableValueRule
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.actionvariable.ActionVariableValueRule#validateVariableValue(com.tandbergtv.watchpoint.studio.validation.model.ActionVariable,
	 *      java.util.List)
	 */
	@Override
	protected void validateVariableValue(ActionVariable target, List<ValidationMessage> messages)
	{
		String value = target.getElement().getValue();
		if (value == null)
			value = "";

		try
		{
			int intValue = Integer.parseInt(value);
			if (intValue <= 0)
			{
				ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_VALUE_NOT_POSITIVE_INTEGER;
				List<String> parameters = new ArrayList<String>();
				parameters.add(target.getElement().getName());
				ValidationMessageAdder.getInstance().addValidationMessage(messages, target.getNode(), code, parameters);
			}
		}
		catch (NumberFormatException nfe)
		{
			ValidationMessageCode code = ValidationMessageCode.ACTION_VARIABLE_VALUE_NOT_POSITIVE_INTEGER;
			List<String> parameters = new ArrayList<String>();
			parameters.add(target.getElement().getName());
			ValidationMessageAdder.getInstance().addValidationMessage(messages, target.getNode(), code, parameters);
		}
	}
}
