package com.tandbergtv.watchpoint.studio.validation.rules.mailnode;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class MailNodeBasicPropertiesRule extends ValidationRule<MailNode>{

	@Override
	public List<ValidationMessage> validateRule(MailNode target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		//name
		validateNotNullAndNotBlank(target, target.getTo(), ValidationMessageCode.MAILNODE_DESTINATION_BLANK, messages);
		
		//to
		validateTextMaxLength(target.getTo(), 255, target,
							  ValidationMessageCode.MAILNODE_DESTINATION_TOO_LARGE, messages);

		// subject
		if (target.getSubject() != null) {
			validateTextMaxLength(target.getSubject().getSubject(), 500, target,
					  ValidationMessageCode.MAILNODE_SUBJECT_TOO_LARGE, messages);
		}
		
		// body
		if (target.getText() != null) {
			validateTextMaxLength(target.getText().getText(), 500, target,
					  ValidationMessageCode.MAILNODE_BODY_TOO_LARGE, messages);
		}
		
		// attachment
		validateTextMaxLength(target.getAttachment(), 255, target,
				  ValidationMessageCode.MAILNODE_ATTACHMENT_TOO_LARGE, messages);

		return messages;
	}

	private void validateNotNullAndNotBlank(MailNode target,
			String property, ValidationMessageCode errorCode,
			List<ValidationMessage> messages) {
		if (isNullOrBlank(property)) {
		    ValidationMessageAdder.getInstance().addValidationMessage(messages, target, errorCode);
		}
	}
	private boolean isNullOrBlank(String str)
	{
		if(str == null || str.trim().length() == 0) {
			return true;
		} else {
			return false;
		}
	}
	
	private void validateTextMaxLength(String text, int maxSize,
									   MailNode target, ValidationMessageCode errorCode,
									   List<ValidationMessage> messages) {
		if (text != null && text.length() > maxSize) {
		    ValidationMessageAdder.getInstance().addValidationMessage(messages, target, errorCode);
		}
	}
	
}
