/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.manualtasknode;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation rule that verifies that a Manual Task Node has at least one variable defined.
 * 
 * @author Patrik Araujo
 */
public class VariableRequiredRule extends ValidationRule<IWPVariableContainer> {

	/**
	 * Check that a IWPVariableContainer has at least one variable defined.
	 * 
	 * @param target
	 *            The IWPVariableContainer to validate
	 * 
	 * @return The List of validation messages
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(IWPVariableContainer target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		List<WPVariable> nodeVariables = target.getVariables();
		if (nodeVariables == null || nodeVariables.size() == 0){
			ValidationMessageCode code = ValidationMessageCode.NODE_MISSING_VARIABLES;
			ValidationMessageAdder.getInstance().addValidationMessage(messages, target, code);
		}

		return messages;
	}
}
