/*
 * Created on Nov 6, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.template;

import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.NodeNamesUniqueRule;

/**
 * Validate that all top-level nodes contained in the Workflow Template have a unique name
 * 
 * @author Vijay Silva
 */
public class TemplateNodeNamesUniqueRule extends NodeNamesUniqueRule<WorkflowTemplate>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.NodeNamesUniqueRule#getDuplicateNodeNameValidationCode()
	 */
	@Override
	protected ValidationMessageCode getDuplicateNodeNameValidationCode()
	{
		return ValidationMessageCode.TEMPLATE_NODE_NAME_NOT_UNIQUE;
	}
}
