/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.AbstractMessageNodeSimulator;
import java.util.Collection;
import java.util.Collections;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.instantiation.FieldInstantiator;

public class AutomaticTaskNodeSimulator
extends AbstractMessageNodeSimulator {
    protected Collection<VariableAccess> variables = null;

    @Override
    public void simulate() throws Exception {
        if (SimulationType.EXECUTE.equals((Object)this.simulationConfig.getSimulationType())) {
            TaskNode taskNode = (TaskNode)this.node;
            String className = taskNode.getAction().getActionDelegation().getClassName();
            try {
                FieldInstantiator instantiator = new FieldInstantiator();
                Class<?> actionClass = Class.forName(className);
                String configuration = taskNode.getAction().getActionDelegation().getConfiguration();
                ActionHandler actionHandler = (ActionHandler)instantiator.instantiate(actionClass, configuration);
                actionHandler.execute(this.executionContext);
            }
            catch (Exception e) {
                String msg = "Error while invoking class: " + className;
                throw new NodeSimulationException(msg, this.node, this, e);
            }
        }
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        return Collections.emptyList();
    }
}

