/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.ProcessEventListener;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.EventListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;
import com.tandbergtv.workflow.core.event.IColleague;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EventDispatcher {
    public static final String SUSPENDED_EVENT = "suspended";
    public static final String RESUMED_EVENT = "resumed";
    public static final String STARTED_EVENT = "started";
    public static final String ABORTED_EVENT = "aborted";
    private Set<EventListener> listeners = new HashSet<EventListener>();
    private ProcessEventListener colleague;

    public EventDispatcher(EventListener listener) {
        this.listeners.add(listener);
        this.colleague = new ProcessEventListener(this);
        DefaultMediator.getInstance().register((IColleague)this.colleague);
    }

    public EventDispatcher(Collection<EventListener> listeners) {
        for (EventListener eventListener : listeners) {
            this.listeners.add(eventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(String event) {
        Iterator<EventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            EventListener listener;
            EventListener eventListener = listener = iterator.next();
            synchronized (eventListener) {
                listener.setEvent(event);
                listener.notify();
            }
        }
    }

    public void started() {
        this.fireEvent(STARTED_EVENT);
    }

    public void resumed() {
        this.fireEvent(RESUMED_EVENT);
    }

    public void suspended(String nodeName) {
        this.fireEvent(SUSPENDED_EVENT + " breakpoint " + nodeName);
    }

    public void aborted(String errorMessage) {
        this.fireEvent(ABORTED_EVENT + " " + errorMessage);
    }

    public void addListener(EventListener listener) {
        this.listeners.add(listener);
    }
}

