/**
 * Breakpoint.java
 * Created Aug 24, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.debug;

import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;

import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;

/**
 * A breakpoint. Execution pauses here until UI resumes.
 * 
 * @author Sahil Verma
 */
public class Breakpoint implements ActionHandler {
	
	private static final Logger logger = Logger.getLogger(Breakpoint.class);

	private static final long serialVersionUID = 1L;

	/*
	 * {@inheritDoc}
	 */
	@Override
	public void execute(ExecutionContext context) throws Exception {
		Transition t = context.getTransition();
		CustomToken token = (CustomToken) context.getToken();
		Node node = token.getCurrentNode();

		logger.debug(token + " trying to stop at " + node.getName());

		try {
			if (t == null)
				return;

			WorkflowProcess process = token.getProcessInstance();

			Commands.removeBreakpoint(process, node);
			Commands.suspend(process);
			
			logger.info(token + " hit breakpoint at " + node.getName());
		} catch (Throwable e) {
			logger.warn(token + " problem during breakpoint", e);
		}
	}
}
