package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.swt.widgets.Composite;
import org.jbpm.gd.jpdl.model.Decision;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;

public class NodeSimulationWidgetFactory {

	/**
	 * 		Gets a composite for editing the node specific properties.
	 *  
	 * @param node
	 * @param parent
	 * @return
	 */
	public static AbstractNodeSimulationComposite getCompositeForNode(NodeSimulationConfig node, Composite parent) {
		AbstractNodeSimulationComposite composite = null;
		if (node.getNodeElement() instanceof Decision) {
			composite = new DecisionNodeSimulationComposite(parent, node);
		} else if (node.getNodeElement() instanceof AutomaticTaskNode) {
			composite = new AutoTaskNodeSimulationComposite(parent, node);
		} else if (node.getNodeElement() instanceof LoopNode) {
			composite = new LoopNodeSimulationComposite(parent, node);
		} else if (node.getNodeElement() instanceof MailNode) {
			composite = new MailNodeSimulationComposite(parent, node);
		} else {
			composite = new ParameterizableNodeSimulationComposite(parent, node);
		}
		
		return composite;
	}

}
