package com.tandbergtv.watchpoint.studio.debugger.ui;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TableItem;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;


/**
 * This class implements an ICellModifier
 * An ICellModifier is called when the user modifes a cell in the 
 * tableViewer
 */
public class VariableValuesTableCellModifier implements ICellModifier {
	
	protected VariableValuesTable templateNodesTable;
	
	/**
	 * Constructor 
	 * 
	 * @param templateNodesTable an instance of a NodeSimulationTable 
	 */
	public VariableValuesTableCellModifier(VariableValuesTable templateNodesTable) {
		super();
		this.templateNodesTable = templateNodesTable;
	}

	/**
	 * @see org.eclipse.jface.viewers.ICellModifier#canModify(java.lang.Object, java.lang.String)
	 */
	public boolean canModify(Object element, String property) {
		boolean canModify = false;
		if (VariableValuesTable.VALUE_COLUMN.equals(property)) {
			WPVariable variable = (WPVariable) element;
			/* Unmapped variables can't be modified:
			 *  	- Comes in handy when node has many return values but the node
			 *  ignores some of them. 
			 */
			canModify = variable.isWritable() && variable.getName() != null;
		}
		
		return canModify;
	}

	public Object getValue(Object element, String property) {
		Object result = null;
		
		if (VariableValuesTable.VALUE_COLUMN.equals(property)) {
			WPVariable variable = (WPVariable) element;
			result = variable.getValue();
		}
		
		if (result == null) {
			result = "";
		}
		
		return result;	
	}

	/**
	 * @see org.eclipse.jface.viewers.ICellModifier#modify(java.lang.Object, java.lang.String, java.lang.Object)
	 */
	public void modify(Object element, String property, Object value) {	
		TableItem item = (TableItem) element;
		if (VariableValuesTable.VALUE_COLUMN.equals(property)) {
			WPVariable variable = (WPVariable) item.getData();
			variable.setValue(value.toString());
			templateNodesTable.updateNode(variable);
		}

	}
}
