package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.ProcessEventListener;
import com.tandbergtv.workflow.core.event.DefaultMediator;

public class EventDispatcher {
    public static final String SUSPENDED_EVENT = "suspended";
    public static final String RESUMED_EVENT = "resumed";
    public static final String STARTED_EVENT = "started";
    public static final String ABORTED_EVENT = "aborted";
    private Set<EventListener> listeners = new HashSet<EventListener>();
    private ProcessEventListener colleague;

    public EventDispatcher(EventListener listener) {
        listeners.add(listener);
        colleague = new ProcessEventListener(this);
        DefaultMediator.getInstance().register(colleague);
    }

    public EventDispatcher(Collection<EventListener> listeners) {
        for (EventListener eventListener : listeners) {
            this.listeners.add(eventListener);
        }
    }

    private void fireEvent(String event) {
        for (EventListener listener : listeners) {
            synchronized (listener) {
                listener.setEvent(event);
                listener.notify();
            }
        }
    }

    public void started() {
        fireEvent(STARTED_EVENT);
    }

    public void resumed() {
        fireEvent(RESUMED_EVENT);
    }

    public void suspended(String nodeName) {
        fireEvent(new StringBuilder().append(SUSPENDED_EVENT).append(" breakpoint ").append(nodeName).toString());
    }

    public void aborted(String errorMessage) {
        fireEvent(new StringBuilder().append(ABORTED_EVENT).append(" ").append(errorMessage).toString());
    }

    public void addListener(EventListener listener) {
        listeners.add(listener);
    }
}