package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.log4j.Logger;

/**
 * A class that can write back to the client the events occurred in the runtime.
 * 
 * @author beroubach
 */
public class EventListener extends SocketListener {

    private String event;
    private Logger logger = Logger.getLogger(EventListener.class);

    public EventListener(ServerSocket serverSocket) {
        super(serverSocket);
    }

    @Override
    protected synchronized void processClientSocket(Socket clientSocket) throws IOException {
        try {
            PrintWriter sendToClient = new PrintWriter(clientSocket.getOutputStream(), true);

            while (true) {
                wait();

                synchronized(event) {
                    sendToClient.println(event);

                    logger.debug("event just sent to client: " + event);
                    
                    if (EventDispatcher.ABORTED_EVENT.startsWith(event)) {
                        break;
                    }
                }
            }

            sendToClient.close();

        } catch (InterruptedException e) {
            treatException(e);
        }
    }

    public void setEvent(String event) {
        this.event = event;
    }
}