/*
 * Created on Aug 29, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.application;

/**
 * The Property Keys used in the Application Properties.
 * 
 * @author Vijay Silva
 */
public final class ApplicationPropertyKeys {

	private ApplicationPropertyKeys() {
	}

	/**
	 * The Application Property Key for the Deployment Key used in Message UID Generation
	 */
	public static final String DEPLOYMENT_KEY = "DeploymentKey";

	/**
	 * The Application Property Key for the Workflow System Resource Type System Id
	 */
	public static final String WORKFLOW_SYSTEM_ID = "WFS.ResourceType.SystemId";

	/**
	 * The Application Property Key for the Human Resource Type System Id
	 */
	public static final String HUMAN_SYSTEM_ID = "Human.ResourceType.SystemId";

	/**
	 * The Application Property Key that specifies the Task Handler to use for Manual Tasks.
	 */
	public static final String MANUAL_TASK_HANDLER = "ManualTask.Handler";

	/**
	 * The Application Property Key that specifies the default outgoing Action Handler to use for
	 * Automatic Nodes.
	 */
	public static final String AUTO_TASK_OUTGOINGHANDLER = "AutoTask.OutgoingHandler";

	/**
	 * The Application Property Key that specifies the default incoming Action Handler to use for
	 * Automatic Nodes.
	 */
	public static final String AUTO_TASK_INCOMINGHANDLER = "AutoTask.IncomingHandler";

	/**
	 * The Application Property Key that specifies the default outgoing Action Handler to use for
	 * Automatic Nodes that send attachments.
	 */
	public static final String AUTO_TASK_ATTACHMENTHANDLER = "AutoTask.AttachmentHandler";
}
