/*
 * Created on Jun 21, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess;

import java.io.Serializable;
import java.util.List;

import com.tandbergtv.watchpoint.studio.dto.IPersistable;

/**
 * Data Access for JPA that provides additional JPA functionality.
 * 
 * @param <EC>
 *            The Entity Class
 * @param <EKC>
 *            The Entity Key Class
 * 
 * @author Vijay Silva
 */
public interface DataAccessInterface<EC extends IPersistable, EKC extends Serializable>
{
	/**
	 * @param entity
	 *            The entity to create in the persistence layer
	 * 
	 * @return The created entity
	 */
	EC create(EC entity);

	/**
	 * @param entity
	 *            The entity to update in the persistence layer
	 * 
	 * @return The updated entity
	 */
	EC update(EC entity);

	/**
	 * Deletes an entity from the persistence layer. Does nothing if the key does not exist.
	 * 
	 * @param key
	 *            The Key to the entity that needs to be deleted
	 */
	void delete(EKC key);

	/**
	 * Method to find a entity of the specified type given the key
	 * 
	 * @param key
	 *            The key to the entity that needs to be fetched
	 * 
	 * @return The matching entity in the persistence layer, or null if no matching entity exists.
	 */
	EC find(EKC key);

	/**
	 * Method to find all entities of the specified type in the persistence layer
	 * 
	 * @return The list of all entities stored in the persistence layer
	 */
	List<EC> findAll();

	/**
	 * Get the Persistence Context used for data access operations by this DAO.
	 * 
	 * @return The Persistence Context
	 */
	IPersistenceContext getPersistenceContext();
}
