/*
 * Created on Jun 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess;

import java.util.List;

import com.tandbergtv.watchpoint.studio.dto.Message;

/**
 * The Data Access Interface for the Message entity.
 * 
 * @author Vijay Silva
 */
public interface MessageDAI extends DataAccessInterface<Message, Long>
{
	/**
	 * Get the list of Messages for a Resource Type that are not used by a single-node Node
	 * Definition.
	 * 
	 * @param resourceTypeId
	 *            The Resource Type Id
	 * 
	 * @return The messages for a Resource Type that are not used by a Node Definition.
	 */
	List<Message> findUnusedByResourceType(long resourceTypeId);
	
	/**
	 * Get the list of Messages for a Resource Type that are not used by any single-node Node
	 * Definition except the node definition whose id is passed.
	 * 
	 * @param resourceTypeId
	 *            The Resource Type Id
	 * @param nodeDefinitionId
	 * 			the id of the node definition whose message is not to be excluded
	 * 
	 * @return The messages for a Resource Type that are not used by any single-node 
	 *	Node Definition other than the specified node definition.
	 */
	List<Message> findUnusedByResourceType(long resourceTypeId, long nodeDefinitionId);

	/**
	 * Find the message with the given UID.
	 * 
	 * @param messageUID
	 *            The Message UID
	 * @return The Message
	 */
	Message findByUID(String messageUID);

	/**
	 * Gets the count of Messages with a matching UID.
	 * 
	 * @param uid
	 *            The Message UID to match to
	 * 
	 * @return The number of messages for the matching Message UID.
	 */
	int getCountByUID(String uid);

	/**
	 * Gets the count of Messages with a matching name for a specific Resource Type.
	 * 
	 * @param resourceTypeId
	 *            The Resource Type to match to
	 * @param name
	 *            The Name of the Message to match to
	 * 
	 * @return The number of messages for the matching resource type with (case insensitive)
	 *         matching names.
	 */
	int getCountByResourceTypeAndName(long resourceTypeId, String name);
}
