/*
 * Created on Jun 1, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

/**
 * Connection Type represents the different formats that the connection string of a Resource could
 * possibly take (example: email, URL, etc).
 * 
 * @author Vijay Silva
 */
public class ConnectionType implements IWatchPointDTO, IPersistable
{
	private static final long serialVersionUID = 4355535381486852915L;

	private long id = DEFAULT_ID;

	private String name;

	/**
	 * Constructor
	 */
	public ConnectionType()
	{
	}

	/**
	 * Constructor
	 * 
	 * @param connectionTypeId
	 *            The Connection Type Id
	 * @param name
	 *            The name
	 */
	public ConnectionType(long connectionTypeId, String name)
	{
		this.setId(connectionTypeId);
		this.setName(name);
	}

	/**
	 * The Connection Type Key is a long value.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * Get the Connection Type Id
	 * 
	 * @return The connection type id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * Set the Connection Type Id
	 * 
	 * @param id
	 *            The connection type id
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * Get the name of the Connection Type
	 * 
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * Set the name of the Connection Type
	 * 
	 * @param name
	 *            the name
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	// ========================================================================
	// ================= OVERRIDEN METHODS
	// ========================================================================

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 4 + 572;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof ConnectionType))
			return false;

		ConnectionType connectionType = (ConnectionType) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && connectionType.id == DEFAULT_ID)
			return super.equals(connectionType);

		return (this.id == connectionType.id);
	}

	/**
	 * @see java.lang.Object#clone()
	 */
	@Override
	public ConnectionType clone()
	{
		ConnectionType clone = null;

		try
		{
			clone = (ConnectionType) super.clone();
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
}
