/*
* Created on June 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;


/**
 * The Template Node Definition DTO.
 * 
 * @author Francisco B. S. Neto
 * 
 */
public class TemplateMessageDTO implements IWatchPointDTO, IPersistable {
	
	private static final long serialVersionUID = -379014790956472071L;

	private long id = DEFAULT_ID;

	private String messageUID;
	private String nodeDefinitionName;
	private String systemID;
	private String resourceGroupName;
	private String templateNodeName;
	private NodeDefinitionType nodeType;
	
	public enum TemplateMessageType {  
		SingleNode(0), SuperState(1);
		
		private final Integer value;  
		private TemplateMessageType(Integer value) {  
			this.value = value;  
		}  
		public Integer getValue() {  
			return value;  
		}  
	}  
	
	private WorkflowTemplateDTO template;

	public void setTemplateNodeName(String templateNodeName) {
		this.templateNodeName = templateNodeName;
	}

	public String getTemplateNodeName() {
		return templateNodeName;
	}

	/**
	 * Default Constructor
	 */
	public TemplateMessageDTO()
	{
		super();
	}

	/**
	 * Get the Node Definition Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * 
	 * @return the Id
	 */
	public long getId()
	{
		return id;
	}

	/**
	 * 
	 * @param id
	 *            The Id
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	public String getMessageUID() {
		return messageUID;
	}

	public void setMessageUID(String messageUID) {
		this.messageUID = messageUID;
	}

	public WorkflowTemplateDTO getTemplate() {
		return template;
	}

	public void setTemplate(WorkflowTemplateDTO template) {
		this.template = template;
	}
	
	public String getNodeDefinitionName() {
		return nodeDefinitionName;
	}

	public void setNodeDefinitionName(String nodeDefinitionName) {
		this.nodeDefinitionName = nodeDefinitionName;
	}

	public String getSystemID() {
		return systemID;
	}

	public void setSystemID(String systemID) {
		this.systemID = systemID;
	}

	public NodeDefinitionType getNodeType() {
		return nodeType;
	}

	public void setNodeType(NodeDefinitionType nodeType) {
		this.nodeType = nodeType;
	}
	
	public String getResourceGroupName() {
		return resourceGroupName;
	}

	public void setResourceGroupName(String resourceGroupName) {
		this.resourceGroupName = resourceGroupName;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 7 - 127;
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof TemplateMessageDTO))
			return false;

		TemplateMessageDTO key = (TemplateMessageDTO) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && key.id == DEFAULT_ID)
			return super.equals(key);

		return (this.id == key.id);
	}

	/**
	 * Creates a clone of the Node Definition.
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public TemplateMessageDTO clone()
	{
		TemplateMessageDTO clone = null;

		try
		{
			clone = (TemplateMessageDTO) super.clone();

		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return "MessageUID " + getMessageUID();
	}
}
