/**
 * ImportDataProvider.java
 * Created Feb 16, 2010
 */
package com.tandbergtv.watchpoint.studio.external.imports;

import java.util.Collection;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;

/**
 * Provides items to import
 * 
 * @author Sahil Verma
 */
public interface ImportDataProvider {
	
	/**
	 * Returns the list of items available to import
	 * 
	 * @return
	 */
	Collection<? extends IWatchPointDTO> getItems();
	
	/**
	 * Sets the location from where items need to be imported. Call this before calling getItems
	 * 
	 * @param location
	 */
	void setImportLocation(String location);
	
	/**
	 * Returns the location from which items are going to be imported
	 * @return
	 */
	String getImportLocation();
}
