/*
 * Created on Mar 27, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

/**
 * Descriptor class that stores information about why a descriptor has failed
 * 
 * @author Vijay Silva
 */
public class FailureDescriptor implements WatchPointDescriptor
{
	private static final long serialVersionUID = -8974658887164524272L;

	private String name;

	private String id;
	
	private Date createDate;

	private String pluginId;

	private String extensionId;

	private String summaryMessage;

	private List<String> errorMessages = new ArrayList<String>();

	
	/**
	 * Default Constructor
	 */
	public FailureDescriptor()
	{
		
	}
	
	/**
	 * @param errorMessages	list of error messages
	 */
	public FailureDescriptor(List<String> errorMessages)
	{
		if(errorMessages != null)
			this.errorMessages = errorMessages;
	}

	/**
	 * @return the errorMessages
	 */
	public List<String> getErrorMessages()
	{
		return this.errorMessages;
	}

	/**
	 * @param errorMessages
	 *            the errorMessages to set
	 */
	public void setErrorMessages(List<String> errorMessages)
	{
		this.errorMessages = errorMessages;
	}
	
	/**
	 * @param errorMessage	error message to add to the list of error messages
	 */
	public void addErrorMessage(String errorMessage)
	{
		this.errorMessages.add(errorMessage);
	}
	
	/**
	 * @param errorMessages error messages to add to the list of error messages
	 */
	public void addErrorMessages(Collection<String> errorMessages)
	{
		this.errorMessages.addAll(errorMessages);
	}

	/**
	 * @return Returns the createDate.
	 */
	public Date getCreateDate() {
		return createDate;
	}

	/**
	 * @param createDate The createDate to set.
	 */
	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the systemId
	 */
	public String getId()
	{
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(String id)
	{
		this.id = id;
	}

	/**
	 * @return the summaryMessage
	 */
	public String getSummaryMessage()
	{
		return this.summaryMessage;
	}

	/**
	 * @param summaryMessage
	 *            the summaryMessage to set
	 */
	public void setSummaryMessage(String summaryMessage)
	{
		this.summaryMessage = summaryMessage;
	}

	/**
	 * @return the extensionId
	 */
	public String getExtensionId()
	{
		return this.extensionId;
	}

	/**
	 * @param extensionId
	 *            the extensionId to set
	 */
	public void setExtensionId(String extensionId)
	{
		this.extensionId = extensionId;
	}

	/**
	 * @return the pluginId
	 */
	public String getPluginId()
	{
		return this.pluginId;
	}

	/**
	 * @param pluginId
	 *            the pluginId to set
	 */
	public void setPluginId(String pluginId)
	{
		this.pluginId = pluginId;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public Object clone()
	{
		FailureDescriptor clone = null;

		try
		{
			clone = (FailureDescriptor) super.clone();

			if (this.errorMessages != null)
			{
				clone.errorMessages = new ArrayList<String>(this.errorMessages);
			}
			if (this.createDate != null)
				clone.createDate = (Date) this.createDate.clone();
			
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString()
	{
		return "ID: " + id + " | " +
			   "Name: "  + name + " | " +
			   "Plugin ID: " + pluginId + " | " +
			   "Extension ID: " + extensionId + " | " +
			   "Error Messages: " + errorMessages;
	}
}
