/*
 * Created on Sep 4, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

/**
 * Constants used by the Resource Type Exporter when building the plug-in XML Document.
 * 
 * @author Vijay Silva
 */
public final class JPFConstants
{
	// Cannot instantiate
	private JPFConstants()
	{
	}

	/**
	 * The Public ID specified in the Document Type.
	 */
	public static final String DOCTYPE_PUBLIC_ID = "-//JPF//Java Plug-in Manifest 1.0";

	/**
	 * The System ID specified in the Document Type.
	 */
	public static final String DOCTYPE_SYSTEM_ID = "http://jpf.sourceforge.net/plugin_1_0.dtd";

	/**
	 * The root element of the Plug-in XML document.
	 */
	public static final String ELEM_PLUGIN = "plugin";

	/**
	 * The 'id' attribute for the root Plug-in Element.
	 */
	public static final String ATTR_PLUGIN_ID = "id";

	/**
	 * The 'version' attribute for the root Plug-in Element.
	 */
	public static final String ATTR_PLUGIN_VERSION = "version";

	/**
	 * The 'requires' element that contains the list of plug-ins the current plug-in depends on.
	 */
	public static final String ELEM_REQUIRES = "requires";

	/**
	 * The 'import' element that contains the a plug-in the current plug-in depends on.
	 */
	public static final String ELEM_IMPORT = "import";

	/**
	 * The plug-in id attribute of the 'import' element containing the id of the dependency.
	 */
	public static final String ATTR_IMPORT_PLUGIN_ID = "plugin-id";

	/**
	 * The 'runtime' element that contains all classpath entries for the plugin.
	 */
	public static final String ELEM_RUNTIME = "runtime";

	/**
	 * The 'library' element (child of 'runtime') that specifies a single classpath entry.
	 */
	public static final String ELEM_LIBRARY = "library";

	/**
	 * The 'type' attribute of the 'library' element declaring the library type.
	 */
	public static final String ATTR_LIBRARY_TYPE = "type";

	/**
	 * The 'path' attribute of the 'library' element declaring the plug-in relative path of the
	 * library.
	 */
	public static final String ATTR_LIBRARY_PATH = "path";

	/**
	 * The 'id' attribute of the 'library' element declaring the library id.
	 */
	public static final String ATTR_LIBRARY_ID = "id";

	/**
	 * Possible value for the type attribute of the library element. Specifies the 'code' type
	 * library.
	 */
	public static final String VALUE_LIBRARY_TYPE_CODE = "code";

	/**
	 * Possible value for the type attribute of the library element. Specifies the 'resource' type
	 * library.
	 */
	public static final String VALUE_LIBRARY_TYPE_RESOURCE = "resources";

	/**
	 * The 'extension-point' element that declares a new extension point in the plug-in.
	 */
	public static final String ELEM_EXTENSION_POINT = "extension-point";

	/**
	 * The 'extension' element that declares a new extension in the plug-in.
	 */
	public static final String ELEM_EXTENSION = "extension";

	/**
	 * The 'id' attribute of the 'extension' element.
	 */
	public static final String ATTR_EXTENSION_ID = "id";

	/**
	 * The 'plugin id' attribute of the 'extension' element declaring the plug-in that contains the
	 * extension point this extension extends.
	 */
	public static final String ATTR_EXTENSION_PLUGIN_ID = "plugin-id";

	/**
	 * The 'point-id' attribute of the 'extension' element declaring the extension point Id extended
	 * by the extension.
	 */
	public static final String ATTR_EXTENSION_PLUGIN_POINT_ID = "point-id";

	/**
	 * The 'parameter' element that is used in the extension definition.
	 */
	public static final String ELEM_PARAMETER = "parameter";

	/**
	 * The 'id' attribute for a parameter element
	 */
	public static final String ATTR_PARAMETER_ID = "id";

	/**
	 * The 'value' attribute for a parameter element
	 */
	public static final String ATTR_PARAMETER_VALUE = "value";

	/**
	 * The 'value' element that is used instead of the value attribute when the value is very large
	 */
	public static final String ELEM_VALUE = "value";
}
