/*
 * Created on Aug 28, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.service;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;

/**
 * Interface for generating a new Message UID.
 * 
 * @author Vijay Silva
 */
public interface IMessageUIDGenerator
{
	/**
	 * Generate a Message UID
	 * 
	 * @param message
	 *            The Message for which the new UID is being generated
	 * @param resourceType
	 *            The Resource Type for which the new Message UID is used for
	 * 
	 * @return The new Message UID to use
	 */
	String generateMessageUID(Message message, ResourceType resourceType);
}
