/*
 * Created on Jul 3, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.service;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;

/**
 * Runtime Exception thrown by the Service layer for any errors that occur while performing a
 * service operation.
 * 
 * @author Vijay Silva
 */
public class ServiceException extends StudioRuntimeException
{
	private static final long serialVersionUID = 4328890252246589275L;

	private ServiceErrorCode serviceErrorCode;

	/**
	 * @param errorCode
	 *            The Service Error Code.
	 */
	public ServiceException(ServiceErrorCode errorCode)
	{
		super();
		this.serviceErrorCode = errorCode;
	}

	/**
	 * 
	 * @param errorCode
	 *            The Service Error Code.
	 * @param message
	 *            The detail message.
	 */
	public ServiceException(ServiceErrorCode errorCode, String message)
	{
		super(message);
		this.serviceErrorCode = errorCode;
	}

	/**
	 * @param errorCode
	 *            The Service Error Code.
	 * @param cause
	 *            The cause
	 */
	public ServiceException(ServiceErrorCode errorCode, Throwable cause)
	{
		super(cause);
		this.serviceErrorCode = errorCode;
	}

	/**
	 * @param errorCode
	 *            The Service Error Code.
	 * @param message
	 *            the detail message.
	 * @param cause
	 *            The cause
	 */
	public ServiceException(ServiceErrorCode errorCode, String message, Throwable cause)
	{
		super(message, cause);
		this.serviceErrorCode = errorCode;
	}

	/**
	 * @return the Error Code.
	 */
	public ServiceErrorCode getServiceErrorCode()
	{
		return this.serviceErrorCode;
	}
}
