/*
 * Created on Jun 29, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.service;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;

/**
 * Exception thrown when basic validation of a WatchPointDTO entity fails when performing a service
 * operation.
 * 
 * @author Vijay Silva
 */
public class ServiceValidationException extends ServiceException
{
	private static final long serialVersionUID = 7045667273830246578L;

	private List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

	/**
	 * Constructor
	 */
	public ServiceValidationException()
	{
		super(ServiceErrorCode.GENERAL_VALIDATION_ERROR);
	}

	/**
	 * @param messages
	 * 			The list of validation messages
	 */
	public ServiceValidationException(List<ValidationMessage> messages)
	{
		this();
		this.setValidationMessages(messages);
	}
	
	/**
	 * @param message
	 *            The Error Message
	 * @param messages
	 *            The list of validation messages
	 */
	public ServiceValidationException(String message, List<ValidationMessage> messages)
	{
		super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, message);
		this.setValidationMessages(messages);
	}

	/**
	 * @param message
	 *            The Error Message
	 * @param messages
	 *            The list of validation messages
	 * @param cause
	 *            The cause (nested throwable) for this exception
	 */
	public ServiceValidationException(String message, List<ValidationMessage> messages,
			Throwable cause)
	{
		super(ServiceErrorCode.GENERAL_VALIDATION_ERROR, message, cause);
		this.setValidationMessages(messages);
	}

	/**
	 * Get the map of Validation Rules that were successfully parsed. If none were parsed, returns
	 * an empty map.
	 * 
	 * @return the validationRules that were successfully parsed.
	 */
	public List<ValidationMessage> getValidationMessages()
	{
		return this.messages;
	}

	/**
	 * Set the validation rules that were sucessfully parsed.
	 * 
	 * @param messages
	 *            The validation messages.
	 */
	void setValidationMessages(List<ValidationMessage> messages)
	{
		this.messages.clear();

		if (messages != null)
			this.messages.addAll(messages);
	}

	/**
	 * @see java.lang.Throwable#toString()
	 */
	@Override
	public String toString()
	{
		StringBuilder buf = new StringBuilder();
		buf.append(super.toString());
		buf.append(" Validation Errors: ");
		for (ValidationMessage message : this.messages)
		{
			buf.append(System.getProperty("line.separator"));
			buf.append("\t").append(message.getCode());
			buf.append(": ").append(message.getElement().toString());
		}

		return buf.toString();
	}
}
