package com.tandbergtv.watchpoint.studio.ui.decorator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * 		Decorator for the groups/ folder.
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public class ResourceGroupDecorator implements ILightweightLabelDecorator {

	private static final String GROUPS_FOLDER = "groups";
	private static final String GROUPS_FOLDER_ICON = "resource_group_folder.png";
	
	@Override
	public void addListener(ILabelProviderListener listener) {
	}

	@Override
	public void dispose() {
	}

	@Override
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	@Override
	public void removeListener(ILabelProviderListener listener) {
	}

	@Override
	public void decorate(Object element, IDecoration decoration) {
		if (element instanceof IFolder) {
			IFolder folder = (IFolder) element;
			if (folder.getProjectRelativePath().toPortableString().equals(GROUPS_FOLDER)) {
				decoration.addOverlay(Utility.getImageDescriptor(GROUPS_FOLDER_ICON));
			}
		}
	}
	
}
