package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.draw2d.IFigure;
import org.eclipse.swt.graphics.Color;
import org.jbpm.gd.common.command.AbstractNodeCreateCommand;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.common.part.NodeContainerGraphicalEditPart;
import org.jbpm.gd.common.policy.GraphicalNodeEditPolicy;
import org.jbpm.gd.common.policy.XYLayoutEditPolicy;

import com.tandbergtv.watchpoint.studio.ui.command.WPNodeCreateCommand;

public abstract class NodeContainerGraphicalEditPartCustom extends NodeContainerGraphicalEditPart {

	public NodeContainerGraphicalEditPartCustom(NotationElement notationElement) {
		super(notationElement);
	}

	protected GraphicalNodeEditPolicy createGraphicalNodeEditPolicy() {
		return new WPNodeGraphicalNodeEditPolicy();
	}

	@Override
	protected IFigure createFigure() {
		IFigure figure = super.createFigure();
		/* Change the NodeContainer(loop node) background color */
		figure.setBackgroundColor( new Color(null, 248, 248, 255) );
		return figure;
	}

	protected XYLayoutEditPolicy createXYLayoutEditPolicy() {
		return getLayoutEditPolicy();
	}

	protected XYLayoutEditPolicy getLayoutEditPolicy() {
		return new XYLayoutEditPolicy() {
			protected AbstractNodeCreateCommand createNodeCreateCommand() {
				return new WPNodeCreateCommand();
			}
		};
	}


}
