package com.tandbergtv.watchpoint.studio.ui.editor;

import org.jbpm.gd.common.command.AbstractEdgeCreateCommand;
import org.jbpm.gd.common.command.AbstractEdgeMoveCommand;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.NotationElement;
import org.jbpm.gd.jpdl.model.EndState;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.policy.NodeGraphicalNodeEditPolicy;

/**
 * @author rprakash
 *
 * Custom NodeGraphicalNodeEditPolicy that uses the Watch Point
 * Edge Create Command & Edge Move Command.
 */
public class WPNodeGraphicalNodeEditPolicy extends NodeGraphicalNodeEditPolicy {
	
	/**
	 * @see org.jbpm.gd.jpdl.policy.NodeGraphicalNodeEditPolicy#createEdgeCreateCommand()
	 */
	@Override
	protected AbstractEdgeCreateCommand createEdgeCreateCommand() {
		return new WPEdgeCreateCommand();
	}
	
	/**
	 * @see org.jbpm.gd.jpdl.policy.NodeGraphicalNodeEditPolicy#createEdgeMoveCommand()
	 */
	@Override
	protected AbstractEdgeMoveCommand createEdgeMoveCommand() {
		return new WPEdgeMoveCommand();
	}
	
	/**
	 * @see org.jbpm.gd.jpdl.policy.NodeGraphicalNodeEditPolicy#canStart()
	 */
	@Override
	protected boolean canStart() {
		SemanticElement semanticElement = ((NotationElement)getHost().getModel()).getSemanticElement();
		if (semanticElement instanceof EndState) {
			return false;
		} else {
			return true;
		}
	}
	
	/**
	 * @see org.jbpm.gd.jpdl.policy.NodeGraphicalNodeEditPolicy#canStop()
	 */
	@Override
	protected boolean canStop() {
		SemanticElement semanticElement = ((NotationElement)getHost().getModel()).getSemanticElement();
		if (semanticElement instanceof StartState) {
			return false;
		} else {
			return true;
		}
	}
}
